/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.ContainerType;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.ContainerDecorativeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class ContainerDecorativeBlock
extends DecorativeBlock
implements EntityBlock {
    protected final ContainerType containerType;
    protected final int rowCount;

    public ContainerDecorativeBlock(Builder builder) {
        super(builder);
        this.containerType = builder.containerType;
        this.rowCount = builder.rowCount;
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    public void m_6402_(Level worldIn, BlockPos posIn, BlockState stateIn, LivingEntity entityIn, ItemStack stackIn) {
        BlockEntity blockEntity;
        if (stackIn.m_41788_() && (blockEntity = worldIn.m_7702_(posIn)) instanceof ContainerDecorativeBlockEntity) {
            ContainerDecorativeBlockEntity containerBlockEntity = (ContainerDecorativeBlockEntity)blockEntity;
            containerBlockEntity.m_58638_(stackIn.m_41786_());
        }
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public boolean m_7278_(BlockState stateIn) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)pLevel.m_7702_(pPos));
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState state) {
        return new ContainerDecorativeBlockEntity(pPos, state, this.rowCount);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayIn) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ContainerDecorativeBlockEntity) {
            ContainerDecorativeBlockEntity container = (ContainerDecorativeBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)container);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState pState, Level levelIn, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = levelIn.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Containers.m_19002_((Level)levelIn, (BlockPos)pos, (Container)((Container)blockEntity));
                levelIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(pState, levelIn, pos, pNewState, pIsMoving);
        }
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public static class Builder
    extends DecorativeBlock.Builder {
        private ContainerType containerType = ContainerType.COMMON_REGULAR;
        private int rowCount = 3;

        public Builder(BaseBlockProperty property) {
            super(property);
        }

        public Builder content(ContainerType type) {
            this.containerType = type;
            this.rowCount = type.getRows();
            return this;
        }

        @Override
        public ContainerDecorativeBlock build() {
            return new ContainerDecorativeBlock(this);
        }
    }
}

